****** Do file for: MERF ECE Effects by Decade Analysis
** Created by Emma Hart
** Last edited 7/2/25
** This do file creates the figures presented in the main text and supplement of "Why are Preschool Programs Becoming Less Effective?"



****************
*** FIGURE 1 ***
****************
clear
import excel "[YOURPATH]/meta_avgs_decades.xlsx",firstrow
save "[YOURPATH]/meta_avgs_decades.dta", replace

use [YOURPATH]/MERF_ece.dta, replace
append using [YOURPATH]/meta_avgs_decades.dta

* first collapse the data so we have one post-test and follow-up per treamtent-control contrast at each assessment wave to depict intervention-level trajectories
keep studyname_txname time_cat4 intyear_cat2000 effectsize se_clust testtime_clean effectsize_avg_time0 effectsize_avg_time1
collapse effectsize se_clust testtime_clean effectsize_avg_time0 effectsize_avg_time1, by (studyname_txname time_cat4 intyear_cat2000)
 
sort studyname_txname time_cat4

bysort studyname_txname: gen count = _n
gen se_post = se_clust if count==1
bysort studyname_txname: carryforward se_post, gen(se_post2)
drop se_post
gen weight=(1/(se_post2*se_post2))

separate effectsize, by(intyear_cat2000) gen (effectsize_time)

codebook studyname_txname if intyear_cat2000==0
codebook studyname_txname if intyear_cat2000==0 & time_cat4==1
codebook studyname_txname if intyear_cat2000==1
codebook studyname_txname if intyear_cat2000==1 & time_cat4==1
* 9 in all groups

** setting x axis scale to be average time since intervention end in each bin
sum testtime_clean if time_cat4 ==1 //0
sum testtime_clean if time_cat4 ==2 //11.00952
sum testtime_clean if time_cat4 ==3 //24
sum testtime_clean if time_cat4 ==4 // 77.59552

replace time_cat4=0 if time_cat4 ==1
replace time_cat4=11.00952 if time_cat4 ==2
replace time_cat4=24 if time_cat4 ==3
replace time_cat4= 77.59552 if time_cat4==4 

scatter effectsize_time0 effectsize_time1 effectsize_avg_time0 effectsize_avg_time1 time_cat [aweight=weight], connect(L L L L) lstyle(ci) mcolor("146 192 223" "214 76 69" "67 122 159" "183 29 62") lcolor("146 192 223" "214 76 69" "67 122 159" "183 29 62") msize(vsmall vsmall vsmall vsmall) msymbol(Oh Oh Oh Oh) mlwidth(vthin vthin medthick medthick) lwidth(vthin vthin medthick medthick) xtitle("{stSerif:Time Since End of Intervention}", size(medium)) ytitle("{stSerif:Effect Size}", size(medium)) xlabel(0 "{stSerif:Posttest (0 mo)}" 9.75 "{stSerif:6-12 mo}" 24 "{stSerif:1-2 yrs}" 77.39 "{stSerif:>2 yrs}", labsize(small) glcolor(none)) ylabel(-0.10 "{stSerif:-0.10}" 0 "{stSerif:0.00}" 0.10 "{stSerif:0.10}" 0.20 "{stSerif:0.20}" 0.30 "{stSerif:0.30}" 0.40 "{stSerif:0.40}" 0.50 "{stSerif:0.50}" 0.60 "{stSerif:0.60}" 0.70 "{stSerif:0.70}" 0.80 "{stSerif:0.80}" 0.90 "{stSerif:0.90}" 1.00 "{stSerif:1.00}" 1.10 "{stSerif:1.10}", labsize(small) glcolor(none)) yline(-.10 0 .10 .20 .30 .40 .50 .60 .70 .80 .90 1 1.10, lwidth(thin) lcolor(gs15) lpattern(solid)) legend(off) graphregion(color(white) lwidth(large)) yline(0, lwidth(thin) lcolor(black))
graph export [YOURPATH]/figure1.pdf, replace



*****************
*** FIGURE S1 ***
*****************
** pre 2000 programs, split by intervention type (curricular vs. programmatic)

clear
import excel "[YOURPATH]/meta_avgs_curricular_year0.xlsx",firstrow
save "[YOURPATH]/meta_avgs_curricular_year0.dta", replace

use [YOURPATH]/MERF_ece.dta, replace
append using [YOURPATH]/meta_avgs_curricular_year0.dta

* first collapse the data so we have one post-test and follow-up per treamtent-control contrast at each assessment wave to depict intervention-level trajectories
keep studyname_txname time_cat4 intyear_cat2000 effectsize se_clust testtime_clean curriculard effectsize_avg_curricular0 effectsize_avg_curricular1
collapse effectsize se_clust testtime_clean effectsize_avg_curricular0 effectsize_avg_curricular1, by (studyname_txname time_cat4 intyear_cat2000 curriculard)
 
sort studyname_txname time_cat4

bysort studyname_txname: gen count = _n
gen se_post = se_clust if count==1
bysort studyname_txname: carryforward se_post, gen(se_post2)
drop se_post
gen weight=(1/(se_post2*se_post2))

keep if intyear_cat2000==0 

separate effectsize, by(curriculard) gen (effectsize_curricular)

codebook studyname_txname if curriculard==0 //5
codebook studyname_txname if curriculard==1 //4
codebook studyname_txname if curriculard==0 & time_cat4==1 //5
codebook studyname_txname if curriculard==1 & time_cat4==1 //4

replace time_cat4=0 if time_cat4 ==1
replace time_cat4=11.00952 if time_cat4 ==2
replace time_cat4=24 if time_cat4 ==3
replace time_cat4= 77.59552 if time_cat4==4 

scatter effectsize_curricular0 effectsize_curricular1 effectsize_avg_curricular0 effectsize_avg_curricular1 time_cat [aweight=weight], connect(L L L L) lstyle(ci) mcolor("114 163 201" "152 214 135" "114 163 201" "152 214 135") lcolor("114 163 201" "152 214 135" "114 163 201" "152 214 135") msize(vsmall vsmall vsmall vsmall) msymbol(Oh Oh Oh Oh) mlwidth(vthin vthin medthick medthick) lwidth(vthin vthin medthick medthick) xtitle("{stSerif:Time Since End of Intervention}", size(medium)) ytitle("{stSerif:Effect Size}", size(medium)) xlabel(0 "{stSerif:Posttest (0 mo)}" 9.75 "{stSerif:6-12 mo}" 24 "{stSerif:1-2 yrs}" 77.39 "{stSerif:>2 yrs}", labsize(small) glcolor(none)) ylabel(-0.10 "{stSerif:-0.10}" 0 "{stSerif:0.00}" 0.10 "{stSerif:0.10}" 0.20 "{stSerif:0.20}" 0.30 "{stSerif:0.30}" 0.40 "{stSerif:0.40}" 0.50 "{stSerif:0.50}" 0.60 "{stSerif:0.60}" 0.70 "{stSerif:0.70}" 0.80 "{stSerif:0.80}" 0.90 "{stSerif:0.90}" 1.00 "{stSerif:1.00}" 1.10 "{stSerif:1.10}", labsize(small) glcolor(none)) yline(-.10 0 .10 .20 .30 .40 .50 .60 .70 .80 .90 1 1.10, lwidth(thin) lcolor(gs15) lpattern(solid)) legend(off) graphregion(color(white) lwidth(large)) yline(0, lwidth(thin) lcolor(black))
graph export [YOURPATH]/figureS1.pdf, replace


*****************
*** FIGURE S2 ***
*****************
** 2000 on programs, split by intervention type (curricular vs. programmatic)

clear
import excel "[YOURPATH]/meta_avgs_curricular_year1.xlsx",firstrow
save "[YOURPATH]/meta_avgs_curricular_year1.dta", replace

use [YOURPATH]/MERF_ece.dta, replace
append using [YOURPATH]/meta_avgs_curricular_year1.dta

* first collapse the data so we have one post-test and follow-up per treamtent-control contrast at each assessment wave to depict intervention-level trajectories
keep studyname_txname time_cat4 intyear_cat2000 effectsize se_clust testtime_clean curriculard effectsize_avg_curricular0 effectsize_avg_curricular1
collapse effectsize se_clust testtime_clean effectsize_avg_curricular0 effectsize_avg_curricular1, by (studyname_txname time_cat4 intyear_cat2000 curriculard)
 
sort studyname_txname time_cat4

bysort studyname_txname: gen count = _n
gen se_post = se_clust if count==1
bysort studyname_txname: carryforward se_post, gen(se_post2)
drop se_post
gen weight=(1/(se_post2*se_post2))

keep if intyear_cat2000==1

separate effectsize, by(curriculard) gen (effectsize_curricular)

codebook studyname_txname if curriculard==0 //2 
codebook studyname_txname if curriculard==1 //7
codebook studyname_txname if curriculard==0 & time_cat==1 //2
codebook studyname_txname if curriculard==1 & time_cat==1 //7

replace time_cat4=0 if time_cat4 ==1
replace time_cat4=11.00952 if time_cat4 ==2
replace time_cat4=24 if time_cat4 ==3
replace time_cat4= 77.59552 if time_cat4==4  

scatter effectsize_curricular0 effectsize_curricular1 effectsize_avg_curricular0 effectsize_avg_curricular1 time_cat [aweight=weight], connect(L L L L) lstyle(ci) mcolor("189 39 63" "244 127 74" "189 39 63" "244 127 74") lcolor("189 39 63" "244 127 74" "189 39 63" "244 127 74") msize(vsmall vsmall vsmall vsmall) msymbol(Oh Oh Oh Oh) mlwidth(vthin vthin medthick medthick) lwidth(vthin vthin medthick medthick) xtitle("{stSerif:Time Since End of Intervention}", size(medium)) ytitle("{stSerif:Effect Size}", size(medium)) xlabel(0 "{stSerif:Posttest (0 mo)}" 9.75 "{stSerif:6-12 mo}" 24 "{stSerif:1-2 yrs}" 77.39 "{stSerif:>2 yrs}", labsize(small) glcolor(none)) ylabel(-0.10 "{stSerif:-0.10}" 0 "{stSerif:0.00}" 0.10 "{stSerif:0.10}" 0.20 "{stSerif:0.20}" 0.30 "{stSerif:0.30}" 0.40 "{stSerif:0.40}" 0.50 "{stSerif:0.50}" 0.60 "{stSerif:0.60}" 0.70 "{stSerif:0.70}" 0.80 "{stSerif:0.80}" 0.90 "{stSerif:0.90}" 1.00 "{stSerif:1.00}" 1.10 "{stSerif:1.10}", labsize(small) glcolor(none)) yline(-.10 0 .10 .20 .30 .40 .50 .60 .70 .80 .90 1 1.10, lwidth(thin) lcolor(gs15) lpattern(solid)) legend(off) graphregion(color(white) lwidth(large)) yline(0, lwidth(thin) lcolor(black))
graph export [YOURPATH]/figureS2.pdf, replace


*****************
*** FIGURE S3 ***
*****************
** pre 2000 programs, split by outcome
 
clear
import excel "[YOURPATH]/meta_avgs_cog.xlsx",firstrow
save "[YOURPATH]/meta_avgs_cog.dta", replace

use [YOURPATH]/MERF_ece.dta, replace
append using [YOURPATH]/meta_avgs_cog.dta

* first collapse the data so we have one post-test and follow-up per treamtent-control contrast at each assessment wave to depict intervention-level trajectories
keep studyname_txname time_cat4 intyear_cat2000 effectsize se_clust testtime_clean cognitived effectsize_avg_cog0 effectsize_avg_cog1
collapse effectsize se_clust testtime_clean effectsize_avg_cog0 effectsize_avg_cog1, by (studyname_txname time_cat4 intyear_cat2000 cognitived)
 
sort studyname_txname cognitived time_cat4

bysort studyname_txname cognitived: gen count = _n
gen se_post = se_clust if count==1
bysort studyname_txname: carryforward se_post, gen(se_post2)
drop se_post
gen weight=(1/(se_post2*se_post2))

keep if intyear_cat2000==0 

separate effectsize, by(cognitived) gen (effectsize_cog)

codebook studyname_txname if cognitived==0 //4
codebook studyname_txname if cognitived==1 //9

codebook studyname_txname if cognitived==0 & time_cat4==1 //2 w post-test
codebook studyname_txname if cognitived==1 & time_cat4==1 //9

replace time_cat4=0 if time_cat4 ==1
replace time_cat4=11.00952 if time_cat4 ==2
replace time_cat4=24 if time_cat4 ==3
replace time_cat4= 77.59552 if time_cat4==4 

scatter effectsize_cog0 effectsize_cog1 effectsize_avg_cog0 effectsize_avg_cog1 time_cat [aweight=weight], connect(L L L L) lstyle(ci) mcolor("114 163 201" "152 214 135" "114 163 201" "152 214 135") lcolor("114 163 201" "152 214 135" "114 163 201" "152 214 135") msize(vsmall vsmall vsmall vsmall) msymbol(Oh Oh Oh Oh) mlwidth(vthin vthin medthick medthick) lwidth(vthin vthin medthick medthick) xtitle("{stSerif:Time Since End of Intervention}", size(medium)) ytitle("{stSerif:Effect Size}", size(medium)) xlabel(0 "{stSerif:Posttest (0 mo)}" 9.75 "{stSerif:6-12 mo}" 24 "{stSerif:1-2 yrs}" 77.39 "{stSerif:>2 yrs}", labsize(small) glcolor(none)) ylabel(-0.10 "{stSerif:-0.10}" 0 "{stSerif:0.00}" 0.10 "{stSerif:0.10}" 0.20 "{stSerif:0.20}" 0.30 "{stSerif:0.30}" 0.40 "{stSerif:0.40}" 0.50 "{stSerif:0.50}" 0.60 "{stSerif:0.60}" 0.70 "{stSerif:0.70}" 0.80 "{stSerif:0.80}" 0.90 "{stSerif:0.90}" 1.00 "{stSerif:1.00}" 1.10 "{stSerif:1.10}", labsize(small) glcolor(none)) yline(-.10 0 .10 .20 .30 .40 .50 .60 .70 .80 .90 1 1.10, lwidth(thin) lcolor(gs15) lpattern(solid)) legend(off) graphregion(color(white) lwidth(large)) yline(0, lwidth(thin) lcolor(black))
graph export [YOURPATH]/figureS3.pdf, replace



*****************
*** FIGURE S4 ***
*****************
** post 2000 programs, split by outcome

clear
import excel "[YOURPATH]/meta_avgs_cog.xlsx",firstrow
save "[YOURPATH]/meta_avgs_cog.dta", replace

use [YOURPATH]/MERF_ece.dta, replace
append using [YOURPATH]/meta_avgs_cog.dta

* first collapse the data so we have one post-test and follow-up per treamtent-control contrast at each assessment wave to depict intervention-level trajectories
keep studyname_txname time_cat4 intyear_cat2000 effectsize se_clust testtime_clean cognitived effectsize_avg_cog0 effectsize_avg_cog1
collapse effectsize se_clust testtime_clean effectsize_avg_cog0 effectsize_avg_cog1, by (studyname_txname time_cat4 intyear_cat2000 cognitived)
 
sort studyname_txname cognitived time_cat4

bysort studyname_txname cognitived: gen count = _n
gen se_post = se_clust if count==1
bysort studyname_txname: carryforward se_post, gen(se_post2)
drop se_post
gen weight=(1/(se_post2*se_post2))

keep if intyear_cat2000==1

separate effectsize, by(cognitived) gen (effectsize_cog)

codebook studyname_txname if cognitived==0 //6
codebook studyname_txname if cognitived==1 //9

codebook studyname_txname if cognitived==0 & time_cat4==1 //5 w post-test
codebook studyname_txname if cognitived==1 & time_cat4==1 //9

replace time_cat4=0 if time_cat4 ==1
replace time_cat4=11.00952 if time_cat4 ==2
replace time_cat4=24 if time_cat4 ==3
replace time_cat4= 77.59552 if time_cat4==4 

scatter effectsize_cog0 effectsize_cog1 effectsize_avg_cog0 effectsize_avg_cog1 time_cat [aweight=weight], connect(L L L L) lstyle(ci) mcolor("189 39 63" "250 157 79" "189 39 63" "244 127 74") lcolor("189 39 63" "250 157 79" "189 39 63" "244 127 74") msize(vsmall vsmall vsmall vsmall) msymbol(Oh Oh Oh Oh) mlwidth(vthin vthin medthick medthick) lwidth(vthin vthin medthick medthick) xtitle("{stSerif:Time Since End of Intervention}", size(small)) ytitle("{stSerif:Effect Size}", size(medium)) xlabel(0 "{stSerif:Posttest (0 mo)}" 9.75 "{stSerif:6-12 mo}" 24 "{stSerif:1-2 yrs}" 77.39 "{stSerif:>2 yrs}", labsize(small) glcolor(none)) ylabel(-0.10 "{stSerif:-0.10}" 0 "{stSerif:0.00}" 0.10 "{stSerif:0.10}" 0.20 "{stSerif:0.20}" 0.30 "{stSerif:0.30}" 0.40 "{stSerif:0.40}" 0.50 "{stSerif:0.50}" 0.60 "{stSerif:0.60}" 0.70 "{stSerif:0.70}" 0.80 "{stSerif:0.80}" 0.90 "{stSerif:0.90}" 1.00 "{stSerif:1.00}" 1.10 "{stSerif:1.10}", labsize(small) glcolor(none)) yline(-.10 0 .10 .20 .30 .40 .50 .60 .70 .80 .90 1 1.10, lwidth(thin) lcolor(gs15) lpattern(solid)) legend(off) graphregion(color(white) lwidth(large)) yline(0, lwidth(thin) lcolor(black))
graph export [YOURPATH]/figureS4.pdf, replace


