****** Do file for: MERF Soc vs. Cog Manuscript (Main and Supplemental Analyses)
** Created by Emma Hart (erh2169@tc.columbia.edu)
** Last edited 6/1/24
** This do file contains code for the tables and figures created through Stata (not using meta-regression) for the MERF Soc vs. Cog manuscript and supplemental file. 

cd "[YOURPATH]"

******************************
******************************
***MAIN MANUSCRIPT ANALYSES***
******************************
******************************

****************
*** FIGURE 2 ***
****************

*** Theory Graph
clear
twoway (function y=x, range(-.5 2) text(1.95 1.9 "100% Persistence", placement(west) size(vsmall)) xline(0, lwidth(thin) lcolor(black)) yline(0, lwidth(thin) lcolor(black)) yscale(noline) xscale(noline) yla(, tlength(0) labsize(small)) xla(, tlength(0) labsize(small))) (function y=0, range(-.5 2) text(0.08 1.9 "0% Persistence", placement(west) size(vsmall)) xline(0, lwidth(thin) lcolor(black)) yline(0, lwidth(thin) lcolor(black)) yscale(noline) xscale(noline) yla(, tlength(0) labsize(small)) xla(, tlength(0) labsize(small))) (function y=(.5*x), range(-.5 2) text(1 1.9 "50% Persistence", placement(west) size(vsmall)) xline(0, lwidth(thin) lcolor(black)) yline(0, lwidth(thin) lcolor(black)) yscale(noline) xscale(noline) yla(, tlength(0) labsize(small)) xla(, tlength(0) labsize(small))) (function y=(.5*x) +.5, range(-.5 2) lpattern(-) text(.65 0 "Variable Persistence", placement(west) size(vsmall)) text(.55 0 "(Unmeasured Mediators)", placement(west) size(vsmall)) graphregion(color(white)) xline(0, lwidth(thin) lcolor(black)) yline(0, lwidth(thin) lcolor(black)) yscale(noline) xscale(noline) yla(, tlength(0) labsize(small)) xla(, tlength(0) labsize(small))) (function y=(.5*x) -.5, range(-.5 2) lpattern(-) text(-.55 0 "Variable Persistence", placement(east) size(vsmall)) text(-.65 0 "(Unmeasured Mediators)", placement(east) size(vsmall)) graphregion(color(white)) xline(0, lwidth(thin) lcolor(black)) yline(0, lwidth(thin) lcolor(black)) yscale(noline) xscale(noline) yla(, tlength(0) labsize(small)) xla(, tlength(0) labsize(small))), xtitle("Post-test ES", size(small)) ytitle("Follow-up ES", size(small)) xsc(r(-.5 2)) legend (size(tiny) cols(5) label(1 y=x) label(2 y=0) label(3 y=.5x) label(4 y =.5x+.5) label(5 y =.5x-.5)) graphregion(margin(1 1 1 1)) aspectratio(1) xsize(4) ysize(4) ylabel(#4) xlabel(#4)
graph export theoretical_fadeoutpatterns.pdf, replace 


***************
*** Table 1 ***
***************

use MERF_soc_cog_wide.dta, clear
bysort studyname_txname: gen count_groups=_N
keep studyname_txname count_groups
codebook studyname_txname
duplicates drop
codebook studyname_txname

merge 1:m studyname_txname using "MERF_soc_cog_long.dta"
drop _merge

codebook studyid //68 unique studies
count if time_cat==1 //450 post-tests
count if time_cat!=0 & time_cat!=1 //580 follow-ups
sort studyname_txname
br studyname_txname count_groups

keep socd cognitived pubyear baseline_age tx_intended_months tx_intended_time_hours time_in_school tx_math tx_read_lang tx_science tx_cog tx_ef tx_learningskills tx_socemo tx_substance tx_psych soc_inputd cog_inputd broad_inputd tx_teacher tx_parent asian_total black_total white_total hispanic_total female_total basesample studyname_txname count_groups country_europe country_middle_east country_north_america country_USA country_multiple country_oceania

collapse socd cognitived pubyear baseline_age tx_intended_months tx_intended_time_hours time_in_school tx_math tx_read_lang tx_science tx_cog tx_ef tx_learningskills tx_socemo tx_substance tx_psych soc_inputd cog_inputd broad_inputd tx_teacher tx_parent asian_total black_total white_total hispanic_total female_total basesample count_groups country_europe country_middle_east country_north_america country_USA country_multiple country_oceania, by(studyname_txname)

tab pubyear
** generate median, odd number of observations
sum pubyear, d //median= near 2008
*** since replaced across all outcomes within study, have to correct cognitived var. If it's not 1, that means it was a study that contained both soc and cog viable groups

tab cognitived
tab socd

replace cognitived=1 if cognitived!=0
replace socd=1 if socd!=0

hist tx_intended_time_hours if socd==1
hist tx_intended_time_hours if cognitived==1
sum tx_intended_time_hours if cognitived==1
sum tx_intended_time_hours if socd==1

codebook studyname_txname if socd==1 & cognitived==1

foreach var in tx_teacher tx_parent tx_math tx_read_lang tx_socemo tx_science tx_cog tx_ef tx_learningskills tx_substance tx_psych time_in_school soc_inputd cog_inputd broad_inputd country_europe country_middle_east country_north_america country_USA country_multiple country_oceania{
	
	replace `var'= `var'*100
	
}

*install eststo package

eststo all: estpost summarize pubyear baseline_age tx_intended_months tx_intended_time_hours time_in_school tx_math tx_read_lang tx_science tx_cog tx_ef tx_learningskills tx_socemo tx_substance tx_psych soc_inputd cog_inputd broad_inputd tx_teacher tx_parent asian_total black_total white_total hispanic_total country_europe country_middle_east country_north_america country_USA country_multiple country_oceania female_total count_groups basesample 
eststo soc: estpost summarize pubyear baseline_age tx_intended_months tx_intended_time_hours time_in_school tx_math tx_read_lang tx_science tx_cog tx_ef tx_learningskills tx_socemo tx_substance tx_psych soc_inputd cog_inputd broad_inputd tx_teacher tx_parent asian_total black_total white_total hispanic_total country_europe country_middle_east country_north_america country_USA country_multiple country_oceania female_total count_groups basesample if socd==1
eststo cog: estpost summarize pubyear baseline_age tx_intended_months tx_intended_time_hours time_in_school tx_math tx_read_lang tx_science tx_cog tx_ef tx_learningskills tx_socemo tx_substance tx_psych soc_inputd cog_inputd broad_inputd tx_teacher tx_parent asian_total black_total white_total hispanic_total country_europe country_middle_east country_north_america country_USA country_multiple country_oceania female_total count_groups basesample if cognitived==1
esttab all soc cog using table1.csv, replace cells("count mean(fmt(2)) min(fmt(2)) max(fmt(2))") label


sum tx_intended_time_hours if cognitived==1 & tx_intended_time_hours< 200 & tx_intended_time_hours!=.
sum tx_intended_time_hours if cognitived==0 & tx_intended_time_hours< 200 & tx_intended_time_hours!=.
sum tx_intended_time_hours if cognitived==1 & tx_intended_time_hours< 100 & tx_intended_time_hours!=.
sum tx_intended_time_hours if cognitived==0 & tx_intended_time_hours< 100 & tx_intended_time_hours!=.

* create categorical variable for construct type for tables
* achievement composite=1, attendance=2, cognitive=3, criminality=4, edu attainment=5, externalizing=6, grades/gpa=7, internalizing=8, language and literacy=9, learning skills=10, math=11, mixed composite=12, other academic ability=13, retention=14, social-emotional=15, special edu=16, substance use=17

save studylevel_descriptives_new.dta, replace


** calculate total number of participants [added to table]
use MERF_soc_cog_wide.dta, clear
codebook studyname_txname
codebook studyid

keep if time_cat==1
br studyname_txname cntrl_sample_clean
sort studyname_txname
 
collapse tx_sample_clean cntrl_sample_clean, by(studyid studyname studyname_txname) //collapse so that there is one line per treatment group
codebook studyname_txname //87

generate multipletx=0

decode studyname, gen (studyname_string)

replace multipletx=1 if studyname_string!=studyname_txname

sort studyname_txname
keep studyname_txname studyname_string tx_sample_clean cntrl_sample_clean multipletx studyid

*exporting to excel to look at this and calculate sample size (being careful not to double count control groups when there are multiple tx groups within a study)
save samplesize_calc.dta, replace


***************
*** Table 2 ***
***************
** this code contributes to the information presented in table 2 (does not actually generate the table itself)

** have to merge together the cluster-adjusted p values (which are only in the wide dataset) with the long dataset to have everything needed for this table
use MERF_soc_cog_wide.dta, clear
keep studyname_txname viablegroup effectsize1 effectsize2 effectsize3 effectsize4 effectsize5 effectsize9 p1_clust p2_clust p3_clust p4_clust p5_clust p9_clust 

rename p1_clust p_clust1
rename p2_clust p_clust2
rename p3_clust p_clust3
rename p4_clust p_clust4
rename p5_clust p_clust5
rename p9_clust p_clust6
rename effectsize9 effectsize6

reshape long p_clust effectsize, i(viablegroup) j(time_cat)
drop if p_clust==.

merge 1:1 viablegroup effectsize studyname_txname time_cat using "MERF_soc_cog_long.dta"

sum p_clust
sum p
drop _merge

save MERF_soc_cog_pclust.dta, replace

codebook studyid //68
codebook studyname_txname //87

drop cog soc
tab construct_cat 
tab construct_cat, nolab

count if time_cat!=1
codebook studyname_txname
codebook studyname_txname if cognitived==0
codebook studyname if cognitived==0
codebook studyname_txname if cognitived==1
codebook studyname if cognitived==1
codebook viablegroup if cognitived==0
codebook viablegroup if cognitived==1

generate cog=.
replace cog=1 if construct_cat==9
replace cog=2 if construct_cat==11
replace cog=3 if construct_cat==3
replace cog=4 if construct_cat==13
replace cog=4 if construct_cat==13
replace cog=5 if construct_cat==1

generate soc=.
replace soc=1 if construct_cat==15		 
replace soc=2 if construct_cat==17		 
replace soc=3 if construct_cat==8
replace soc=4 if construct_cat==6
replace soc=5 if construct_cat==4

tab construct_cat if cognitived==1
/*     Construct category |      Freq.     Percent        Cum.
-----------------------+-----------------------------------
 achievement composite |          8        1.50        1.50
             cognitive |         37        6.94        8.44
 language and literacy |        429       80.49       88.93
                  math |         49        9.19       98.12
other academic ability |         10        1.88      100.00
-----------------------+-----------------------------------
                 Total |        533      100.00*/
				
				 
tab construct_cat if cognitived==0
/* 
    Construct category |      Freq.     Percent        Cum.
-----------------------+-----------------------------------
           criminality |         16        3.33        3.33
         externalizing |         66       13.75       17.08
         internalizing |         84       17.50       34.58
      social-emotional |        208       43.33       77.92
         substance use |        106       22.08      100.00
-----------------------+-----------------------------------
                 Total |        480      100.00

*/		

* # of viable groups			 
codebook viablegroup if cog!=.		
forvalues i=1/5 {	
codebook viablegroup if cog==`i'	
} 			 

codebook viablegroup if soc!=.
forvalues i=1/5 {
codebook viablegroup if soc==`i'	
} 	

codebook viablegroup //441
codebook viablegroup if cog_inputd==1 //195 
codebook viablegroup if soc_inputd==1	//196
codebook viablegroup if broad_inputd==1	//50



* total sample size
sum total_sample_clean if cog!=.
forvalues i=1/5 {	
sum total_sample_clean if cog==`i'	
} 	

sum total_sample_clean if soc!=.
forvalues i=1/5 {	
sum total_sample_clean if soc==`i'	
} 
	
sum total_sample_clean if cog_inputd==1	
sum total_sample_clean if soc_inputd==1	
sum total_sample_clean if broad_inputd==1

* number of post-tests and follow-ups
bysort viablegroup: gen assessments=_N if cog!=.
sum assessments

forvalues i=1/5 {	
gen assessments`i' =.
bysort viablegroup: replace assessments`i'=_N
sum assessments`i' if cog==`i'
} 	

bysort viablegroup: gen assessments_s=_N if soc!=.
sum assessments_s

forvalues i=1/5 {	
gen assessmenta`i' =.
bysort viablegroup: replace assessmenta`i'=_N
sum assessmenta`i' if soc==`i'
} 	

bysort viablegroup: gen assessmentz=_N if cog_inputd==1		
sum assessmentz

bysort viablegroup: gen assessmentq=_N if soc_inputd==1		
sum assessmentq

bysort viablegroup: gen assessmentx=_N if broad_inputd==1		
sum assessmentx


* time of test
sum testtime_clean if cog!=.
forvalues i=1/5 {	
sum testtime_clean if cog==`i'	
} 	

sum testtime_clean if soc!=.
forvalues i=1/5 {	
sum testtime_clean if soc==`i'	
} 

sum testtime_clean if cog_inputd==1				 
sum testtime_clean if soc_inputd==1				 
sum testtime_clean if broad_inputd==1	

* statisically significant post-test p-values 
generate statsig=.
replace statsig=1 if p_clust<.05 & p_clust!=.
replace statsig=0 if p_clust>=.05 & p_clust!=.
tab statsig
/*
    statsig |      Freq.     Percent        Cum.
------------+-----------------------------------
          0 |        718       73.79       73.79
          1 |        255       26.21      100.00
------------+-----------------------------------
      Total |        973      100.00
*/

tab statsig if time_cat==1 // 32.22 % statistically signficant
	
tab statsig if cognitived==1 & time_cat==1 
forvalues i=1/5 {	
tab statsig if cog==`i' & time_cat==1	
} 			 

tab statsig if cognitived==0 & time_cat==1 //22.66 %
forvalues i=1/5 {
tab statsig if soc==`i'	& time_cat==1
} 	

tab statsig if cog_inputd==1 & time_cat==1			 
tab statsig if soc_inputd==1 & time_cat==1						 
tab statsig if broad_inputd==1 & time_cat==1					

* treatment groups
codebook studyname_txname  if cog!=.
forvalues i=1/5 {
codebook studyname_txname if cog==`i'	
} 		
	
codebook studyname_txname  if soc!=.
forvalues i=1/5 {
codebook studyname_txname if soc==`i'	
} 		

codebook studyname_txname if cog_inputd==1				 
codebook studyname_txname if soc_inputd==1				 
codebook studyname_txname if broad_inputd==1	
				 

***************
*** Table 3 ***
***************

** See R script



******************
*** Figure 3/4 ***
******************


* determined weighted averages and inputted them into excel as a new viable group/outcome that could be plotted for averages because couldn't figure out how to do weighted averages within the graph script

/*viablegroup	cognitived	effectsizeavg_weighted	time_cat
	500				1				0.4					1
	500				1				0.22				2
	500				1				0.16				3
	500				1				0.05				4
	500				1				0.12				5
	500				1				0.14				9
	501				0				0.14				1
	501				0				0.16				2
	501				0				0.05				3
	501				0				0.11				4
	501				0				0.09				5
	*/

* R mean estimates
clear
import excel "avgeffects_weighted_R.xlsx",firstrow 
save "avgeffects_weighted_R.dta", replace

use MERF_soc_cog_long.dta, clear
append using avgeffects_weighted_R.dta

label variable effectsizeavg_weighted "Average weighted ESs"

graph set window fontface "Times New Roman"

replace time_cat=9 if time_cat==6 //for easy viewing in graphs
tab time_cat

sort viablegroup time_cat

**create post-test n weight var that has reduced variability so coordinates are consistently weighted within sample size range
codebook basesample
tab basesample //1041, no missing (11 rows of data are the means that we just imported in that comprise the full 1030)
* determining the mean sample size within each of the categories we're establishing (effectsize1= effect sizes for samples with n < 100)
sum basesample if effectsize1!=. //m= 65.30579
sum basesample if effectsize2!=. //m= 159.2391
sum basesample if effectsize3!=. //m= 526.3611
sum basesample if effectsize4!=. //m= 3257.872 

gen n_reducedvariability=.
replace n_reducedvariability = 65.30579 if basesample < 100 & basesample!=.
replace n_reducedvariability = 159.2391 if basesample >= 100 & basesample<300 & basesample!=.
replace n_reducedvariability = 526.3611 if basesample >= 300 & basesample<1000 & basesample!=.
replace n_reducedvariability = 3257.872  if basesample >= 1000 & basesample!=.
codebook n_reducedvariability //1,041 with 11 missing for the averaged vars

* for display purposes, dropping one line that is throwing the scale of the cog graph off
generate include=1
replace include=0 if effectsize<-1 & time_cat==1 //1 change - one outlier that makes cog graph on a different scale than cog
tab viablegroup if include==0 //viablegroup=154

scatter effectsize1 effectsize2 effectsize3 effectsize4 effectsizeavg_weighted time_cat if cognitived==1 & viablegroup!=154 [aweight=n_reducedvariability], connect(L L L L L) lstyle(ci) msize(vsmall vsmall vsmall vsmall vsmall) msymbol(Oh Oh Oh Oh) mlwidth(vthin vthin vthin vthin medthick) lwidth(vthin vthin vthin vthin medium) mcolor(sand gold dkorange cranberry blue) lcolor(sand gold dkorange cranberry blue) xtitle("{stSerif:Time Since Post-test}", size(small)) ytitle("{stSerif:Effect Size}", size(small)) xlabel(1 "{stSerif:posttest (0 mo)}" 2 "{stSerif:6-12 mo}" 3 "{stSerif:1-2 yrs}" 4 "{stSerif:2-3 yrs}" 5 "{stSerif:3-4yrs}" 9 "{stSerif:> 4 years}", labsize(vsmall) glcolor(none)) ylabel(-1 "{stSerif:-1}" 0 "{stSerif:0}" 1 "{stSerif:1}" 2 "{stSerif:2}", labsize(vsmall) glcolor(none)) yline(-1 0 1 2, lwidth(thin) lcolor(gs15) lpattern(solid)) legend(off) graphregion(color(white) lwidth(large))
graph export cog_trajectories_r_n_reducedvar.pdf, replace

sort viablegroup time_cat
scatter effectsize1 effectsize2 effectsize3 effectsize4 effectsizeavg_weighted time_cat if cognitived==0 [aweight=n_reducedvariability], connect(L L L L L) lstyle(ci) msize(vsmall vsmall vsmall vsmall vsmall) msymbol(Oh Oh Oh Oh) mlwidth(vthin vthin vthin vthin medthick) lwidth(vthin vthin vthin vthin medium) mcolor(sand gold dkorange cranberry blue) lcolor(sand gold dkorange cranberry blue) xtitle("{stSerif:Time Since Post-test}", size(small)) ytitle("{stSerif:Effect Size}", size(small)) xlabel(1 "{stSerif:posttest (0 mo)}" 2 "{stSerif:6-12 mo}" 3 "{stSerif:1-2 yrs}" 4 "{stSerif:2-3 yrs}" 5 "{stSerif:3-4yrs}", labsize(vsmall) glcolor(none)) ylabel(-1 "{stSerif:-1}" 0 "{stSerif:0}" 1 "{stSerif:1}" 2 "{stSerif:2}", labsize(vsmall) glcolor(none)) yline(-1 0 1 2, lwidth(thin) lcolor(gs15) lpattern(solid)) legend(off) graphregion(color(white) lwidth(large))
graph export soc_trajectories_r_n_reducedvar.pdf, replace


******************
***   Table 4  ***
******************

** See R script


*********************
***   Figure 5/6  ***
*********************

* creating key graphs from R estimates using 1/se^2 as coordinate weight
use MERF_soc_cog_wide.dta, clear

* 6- 12mos
separate effectsize2, by(cognitived) gen (effectsize2_cog)

* restrict graph range for consistency (-1 to 2 SD)
gen restrict_graph_range_effectsize2=0
replace restrict_graph_range_effectsize2=1 if effectsize1>2 & effectsize1!=. | effectsize2_cog0>2 & effectsize2_cog0!=. | effectsize2_cog1>2 & effectsize2_cog1!=. 
replace restrict_graph_range_effectsize2=1 if effectsize1<-1 & effectsize1!=. | effectsize2_cog0<-1 & effectsize2_cog0!=. | effectsize2_cog1<-1 & effectsize2_cog1!=.

gen weight_se2_clust= 1/(se2_clust*se2_clust)

twoway (scatter effectsize2_cog0 effectsize2_cog1 effectsize1 [aweight=weight_se2_clust] if restrict_graph_range_effectsize2!=1, msymbol(Oh Oh) mlwidth(vthin vthin) mcolor("246 199 0" eltblue) msize(small small) xtitle("Post-test ES", size(small)) ytitle("Follow-up ES (6- to 12-months)", size(small)) leg(off) graphregion(color(white)) xline(0, lwidth(thin) lpattern(solid) lcolor(black)) yline(0, lwidth(thin) lpattern(solid) lcolor(black)) xscale(range(-1 2) noline) yscale(range(-1 2) noline) yla(-1 " " 0 " " 1 " " 2, tlength(0) labsize(small) glcolor(none)) xla(-1 " " 0 " " 1 " " 2, tlength(0) labsize(small) glcolor(none)) graphregion(margin(1 1 1 1)) aspectratio(1) xsize(4) ysize(4) ylabel(#4) xlabel(#4)) ///
    (function y=(x), range(-.8 1) lcolor(black) lpattern(dot) lwidth(thick)) ///
    (function y=(.45 * x) + .07, range(-.8 1) lcolor(black) lpattern(solid) lwidth(medium)) ///
    (function y=(.47 * x) + .08, range(-.8 1) lcolor(dkorange) lpattern(solid) lwidth(medium)) ///
    (function y=(.46 * x) + .05, range(-.8 1) lcolor(ebblue) lpattern(solid) lwidth(medium)), ///
    yline(-1 1 2, lwidth(thin) lcolor(gs15) lpattern(solid))
graph export effectsize2_nolab_r.pdf, replace

sum effectsize2_cog0
sum effectsize2_cog1
* 400

/* ALL:
intercept	summary	0.047462621
effectsize1	summary	0.07769865
*/

/*
table4c3p2	intercept	-0.019093303
table4c3p2	effectsize1	0.3371668
table4c3p2	socd	0.067040751
table4c3p2	effectsize1:socd	-0.377217322
*/
* SOC:
display 0.3371668 -0.377217322 //-.04005052
display -0.019093303+ 0.067040751 //.04794745


* 1- 2yrs
separate effectsize3, by(cognitived) gen (effectsize3_cog)

gen restrict_graph_range_effectsize3=0
replace restrict_graph_range_effectsize3=1 if effectsize1>2 & effectsize1!=. | effectsize3_cog0>2 & effectsize3_cog0!=. | effectsize3_cog1>2 & effectsize3_cog1!=. 
replace restrict_graph_range_effectsize3=1 if effectsize1<-1 & effectsize1!=. | effectsize3_cog0<-1 & effectsize3_cog0!=. | effectsize3_cog1<-1 & effectsize3_cog1!=.

gen weight_se3_clust= 1/(se3_clust*se3_clust)

twoway (scatter effectsize3_cog0 effectsize3_cog1 effectsize1 [aweight=weight_se3_clust] if restrict_graph_range_effectsize3!=1, msymbol(Oh Oh) mlwidth(vthin vthin) mcolor("246 199 0" eltblue) msize(small small) xtitle("Post-test ES", size(small)) ytitle("Follow-up ES (1-2 years)", size(small)) leg(off) graphregion(color(white)) xline(0, lwidth(thin) lpattern(solid) lcolor(black)) yline(0, lwidth(thin) lpattern(solid) lcolor(black)) xscale(range(-1 2) noline) yscale(range(-1 2) noline) yla(-1 " " 0 " " 1 " " 2, tlength(0) labsize(small) glcolor(none)) xla(-1 " " 0 " " 1 " " 2, tlength(0) labsize(small) glcolor(none)) graphregion(margin(1 1 1 1)) aspectratio(1) xsize(4) ysize(4) ylabel(#4) xlabel(#4)) ///
    (function y=(x), range(-.8 1) lcolor(gs7) lpattern(dot) lwidth(thick)) ///
    (function y=(.18 * x) + .02, range(-.8 1) lcolor(black) lpattern(solid) lwidth(medium)) ///
    (function y=(-.05 * x) + .05, range(-.8 1) lcolor(dkorange) lpattern(solid) lwidth(medium)) ///
    (function y=(.35 * x) - .02, range(-.8 1) lcolor(ebblue) lpattern(solid) lwidth(medium)), ///
    yline(-1 1 2, lwidth(thin) lcolor(gs15) lpattern(solid))
graph export effectsize3_nolab_r.pdf, replace


******************
***   Table 5  ***
******************

** See R script




******************************
******************************
***. SUPPLEMENT ANALYSES   ***
******************************
******************************


******************
**Figures S2/S3***
******************
use MERF_soc_cog_wide.dta, clear

** fix up studyname_txnames that are too long
replace studyname_txname= "Computer-Assisted Reading~ Read, Write, and Type Group & Lindamood Phoneme Sequencing Program" if studyname_txname=="Computer-Assisted Reading Intervention for Children at Risk of Dyslexia~ Read, Write, and Type and The Lindamood Phoneme Sequencing Program for Reading, Spelling, and Speech Group"

replace studyname_txname= "Computer-Assisted Reading Intervention~ Lindamood Phoneme Sequencing Group" if studyname_txname=="Computer-Assisted Reading Intervention for Children at Risk of Dyslexia~ The Lindamood Phoneme Sequencing Program for Reading, Spelling, and Speech Group"

replace studyname_txname= "Computer-Assisted Reading Intervention~ Read, Write, and Type Group" if studyname_txname=="Computer-Assisted Reading Intervention for Children at Risk of Dyslexia~ Read, Write, and Type Group"

replace studyname_txname= "Head Start REDI~ Promoting Alternative Thinking Strategies Group" if studyname_txname=="Head Start Classroom-based Approaches and Resources for Emotion and Social Skill Promotion~ Preschool Promoting Alternative Thinking Strategies Group"

replace studyname_txname= "Building Blocks" if studyname_txname=="Technology-Enhanced, Research-Based, Instruction, Assessment, and Professional Development Scale-up Model~ Building Blocks Group"
 
replace studyname_txname= "Building Blocks plus TRIAD Follow-Through Group" if studyname_txname=="Technology-Enhanced, Research-Based, Instruction, Assessment, and Professional Development Scale-up Model~ Building Blocks plus TRIAD Follow-Through Group"

replace studyname_txname= "Multi-Component Reading Remediation~ PHAB + RAVE-O" if studyname_txname=="Multi-Component Reading Remediation~ Phonological Analysis and Blending/Direct Instruction and Retrieval, Automaticity, Vocabulary, Engagement with Language, and Orthography Group"

replace studyname_txname= "Multi-Component Reading Remediation~ PHAB + WIST" if studyname_txname=="Multi-Component Reading Remediation~ Phonological Analysis and Blending/Direct Instruction and Word Identification Strategy Training Group"

replace studyname_txname= "Classroom-Centered & School-Family Partnership~ Classroom Group" if studyname_txname=="Classroom-Centered and School-Family Partnership Interventions~ Classroom-Centered Group"

replace studyname_txname= "Classroom-Centered & School-Family Partnership~ Family-School Group" if studyname_txname=="Classroom-Centered and School-Family Partnership Interventions~ Family-School Partnership Group"

replace studyname_txname= "Cognitive-Behavioral Approach to Drug Abuse Prevention ~ In-Person Training" if studyname_txname=="Cognitive-Behavioral Approach to Drug Abuse Prevention ~ Life Skills Training Program with In-Person Teacher Training Group"

replace studyname_txname= "Cognitive-Behavioral Approach to Drug Abuse Prevention ~ Online Training" if studyname_txname=="Cognitive-Behavioral Approach to Drug Abuse Prevention ~ Life Skills Training Program with Online Teacher Training Group"

replace studyname_txname= "Head Start REDI~ Incredible Years Teacher Training Group" if studyname_txname=="Head Start Classroom-based Approaches and Resources for Emotion and Social Skill Promotion~ Incredible Years Teacher Training Group"

replace studyname_txname= "Head Start REDI~ Tools of the Mind Group" if studyname_txname=="Head Start Classroom-based Approaches and Resources for Emotion and Social Skill Promotion~ Tools of the Mind Play Group"

replace studyname_txname= "Omega-Interactive Sentences, Computerized Phonological Training~ Phonological & Comprehension" if studyname_txname=="Omega-Interactive Sentences, Computerized Phonological Training~ Combined Phonological and Comprehension Training Group"

replace studyname_txname= "Strengthening Families Program & Life Skills Training #1~ Both" if studyname_txname=="Strengthening Families Program and Life Skills Training #1~ Life Skills Training and Strengthening Families Group"

replace studyname_txname= "Strengthening Families Program & Life Skills Training #1~ LST Only" if studyname_txname=="Strengthening Families Program and Life Skills Training #1~ Life Skills Training Group"

replace studyname_txname= "Strengthening Families Program & Life Skills Training #1~ LST Only" if studyname_txname=="Strengthening Families Program and Life Skills Training #1~ Life Skills Training Group"

replace studyname_txname= "English Reading Intervention for English Language Learners" if studyname_txname=="English Reading Intervention for English Language Learners~ Study 1 & 4"

replace studyname_txname= "Spanish Reading Intervention for English Language Learners" if studyname_txname=="Spanish Reading Intervention for English Language Learners~ Study 2 & 3"

replace studyname_txname= "Cognitive-Behavioral Approach to Drug Abuse Prevention ~ Both Implementation Arms" if studyname_txname=="Cognitive-Behavioral Approach to Drug Abuse Prevention~ Both Implementation Arms"

save analysis_aligned_viablegroups_forest.dta, replace

keep studyname_txname soc_inputd cog_inputd broad_inputd
duplicates drop
sort studyname_txname

br studyname_txname if soc_inputd==1
br studyname_txname if cog_inputd==1
br studyname_txname if broad_inputd==1


**cog
use analysis_aligned_viablegroups_forest.dta, replace

codebook studyname_txname //87
codebook studyname_txname if cognitived==1 //54
codebook studyname_txname if cognitived==0 //41

drop if cognitived==0
keep studyname_txname total_sample_clean1 cognitived effectsize1 se1_clust

collapse effectsize1 se1_clust cognitived total_sample_clean1, by(studyname_txname)
gen total_sample_clean_round=round(total_sample_clean1)

meta set effectsize1 se1_clust, studylabel(studyname_txname)
replace _meta_studylabel = studyname_txname + " (N = " + string(total_sample_clean_round)+ ")"

meta summarize
meta forestplot, title("Average Post-test Effects for Cognitive Outcomes (unweighted)")
graph export projects/1_hart_soc_vs_cog_manuscript/graphs/post_test_forestplot_cog.pdf, replace


**beh
use analysis_aligned_viablegroups_forest.dta, replace

drop if cognitived==1

collapse effectsize1 se1_clust cognitived total_sample_clean1, by(studyname_txname)
gen total_sample_clean_round=round(total_sample_clean1)

meta set effectsize1 se1_clust, studylabel(studyname_txname)
replace _meta_studylabel = studyname_txname + " (N = " + string(total_sample_clean_round)+ ")"

meta summarize
meta forestplot, title("Average Post-test Effects for Social-Emotional Outcomes (unweighted)")
graph export projects/1_hart_soc_vs_cog_manuscript/graphs/post_test_forestplot_soc.pdf, replace




******************
***  Table S2  ***
******************

** See R Script


******************
***  Table S3  ***
******************

** See R Script


******************
***  Figure S4 ***
******************

*** FUNNEL
** post
use analysis_aligned_viablegroups_forest.dta, replace
keep studyname_txname total_sample_clean1 cognitived se1_clust effectsize1

generate samplesize=round(total_sample_clean, 1)
tab samplesize

collapse se1_clust effectsize1 cognitived total_sample_clean1 samplesize, by(studyname_txname)

generate samplesize2=round(samplesize, 1)
tab samplesize2 //86

meta set effectsize1 se1_clust, studysize(samplesize2)
meta funnelplot, xlabel(-1 -.5 0 .5 1 1.5) xtitle("Post-test Effect Size (n = 86)", size(small)) ytitle("Standard Error", size(small)) graphregion(color(white)) mcolor(black) legend(off) msize(vsmall) saving(zz) 
graph export post_test_funnel_all_post.pdf, replace


** ful1
use analysis_aligned_viablegroups_forest.dta, replace
keep studyname_txname total_sample_clean1 cognitived se2_clust effectsize2
drop if effectsize2==.

generate samplesize=round(total_sample_clean1, 1)
tab samplesize

collapse effectsize2 se2_clust cognitived total_sample_clean1 samplesize, by(studyname_txname)
generate samplesize2=round(samplesize, 1)
tab samplesize2 //77

meta set effectsize2 se2_clust, studysize(samplesize2)
meta funnelplot, xlabel(-1 -.5 0 .5 1 1.5) xtitle("6 - 12 month Follow-up Effect Sizes (n = 77)", size(small)) ytitle("Standard Error", size(small)) graphregion(color(white)) mcolor(black) legend(off) msize(vsmall) saving(xxx) 
graph export post_test_funnel_all_es2.pdf, replace

*fu2
use analysis_aligned_viablegroups_forest.dta, replace
keep studyname_txname total_sample_clean1 cognitived se3_clust effectsize3
drop if effectsize3==.

generate samplesize=round(total_sample_clean, 1)
tab samplesize

collapse effectsize3 se3_clust cognitived total_sample_clean samplesize, by(studyname_txname)

generate samplesize2=round(samplesize, 1)
tab samplesize2 //24

meta set effectsize3 se3_clust, studysize(samplesize2)
meta funnelplot, xlabel(-1 -.5 0 .5 1 1.5) xtitle(">1 year, up to 2 years Follow-up Effect Sizes (n = 24)", size(small)) ytitle("Standard Error", size(small)) graphregion(color(white)) mcolor(black) legend(off) msize(vsmall) saving(cc) 
graph export post_test_funnel_all_es3.pdf, replace

*fu>2
use analysis_aligned_viablegroups_forest.dta, replace
keep studyname_txname total_sample_clean1 cognitived sez_clust effectsizez
drop if effectsizez==.

generate samplesize=round(total_sample_clean, 1)
tab samplesize

collapse effectsizez sez_clust cognitived total_sample_clean samplesize, by(studyname_txname) 

generate samplesize2=round(samplesize, 1)
tab samplesize2 //21

meta set effectsizez sez_clust, studysize(samplesize2)
meta funnelplot, xlabel(-1 -.5 0 .5 1 1.5) xtitle("> 2 years Follow-up Effect Sizes (n = 21)", size(small)) ytitle("Standard Error", size(small)) graphregion(color(white)) mcolor(black) legend(off) msize(vsmall) saving(vvv) 
graph export post_test_funnel_all_esz.pdf, replace

gr combine zz.gph xxx.gph cc.gph vvv.gph, graphregion(color(white))
graph export funnel_all.pdf, replace 


******************
***  Table S4  ***
******************

** See R Script


******************
*** Figure S5  ***
******************

**** preparing export for p-curve website where figures are made: p-curve.com/app4/

use MERF_soc_cog_pclust.dta, clear

generate df= total_sample_clean-2
generate t=abs(invt(df, (p_clust/2))) //divide by 2 for a 2-tailed test

br total_sample_clean p p_clust if t==. //very small p - replace with smallest p
sum p_clust if p_clust!=0 //1.52e-31
replace p_clust=.00000001 if p_clust==0

replace t=abs(invt(df, (p_clust/2))) //1 changes

br viablegroup time_cat effectsize
bysort viablegroup: gen time_4=1 if time_cat==4
bysort viablegroup: gen time_5=1 if time_cat==5
bysort viablegroup: gen time_6=1 if time_cat==6


* looking at the cases where there is more than 1 >2 year follow-up within a viable group
* dropping the earlier of these >2 year follow-ups so that we just have the furthest out follow-up in these cases for the p-curves (this is what was used in the analyses, but was not specified in this long version of the data)
drop if viablegroup==74 & time_cat==4
drop if viablegroup==77 & time_cat==4
drop if viablegroup==232 & time_cat==4
drop if viablegroup==241 & time_cat==4
drop if viablegroup==362 & time_cat==4
drop if viablegroup==382 & time_cat==5
drop if viablegroup==382 & time_cat==4
drop if viablegroup==383 & time_cat==4
drop if viablegroup==384 & time_cat==4
drop if viablegroup==385 & time_cat==4
drop if viablegroup==387 & time_cat==4
drop if viablegroup==392 & time_cat==5
drop if viablegroup==394 & time_cat==4
drop if viablegroup==230 & time_cat==4
drop if viablegroup==238 & time_cat==4
drop if viablegroup==240 & time_cat==4
drop if viablegroup==241 & time_cat==4
drop if viablegroup==386 & time_cat==4
drop if viablegroup==392 & time_cat==4

generate time=.
replace time=1 if time_cat==1 //450
tab p if time==1 
replace time=2 if time_cat==2 //420
tab p if time==2 

replace time=3 if time_cat==3 //87
tab p if time==3 

replace time=4 if time_cat>3 //56
tab p if time==4 //56

export excel t df time using "pcurves", replace
** from here, I just format the columns as is requested on the website (t(xx)=xx) and then copy and paste in the formatted t values for each time period (post, 6-12, etc.)

******************
***  Table S5  ***
******************

** See R Script

